/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

class X500NameTokenizer {
    private String value;
    private int index;
    private char seperator;
    private StringBuffer buf = new StringBuffer();

    public X500NameTokenizer(String string) {
        this(string, ',');
    }

    public X500NameTokenizer(String string, char c2) {
        this.value = string;
        this.index = -1;
        this.seperator = c2;
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        int n2;
        if (this.index == this.value.length()) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        this.buf.setLength(0);
        for (n2 = this.index + 1; n2 != this.value.length(); ++n2) {
            char c2 = this.value.charAt(n2);
            if (c2 == '\"') {
                if (!bl3) {
                    bl2 = !bl2;
                } else {
                    this.buf.append(c2);
                }
                bl3 = false;
                continue;
            }
            if (bl3 || bl2) {
                if (c2 == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                    this.buf.append('\\');
                } else if (c2 == '+' && this.seperator != '+') {
                    this.buf.append('\\');
                }
                this.buf.append(c2);
                bl3 = false;
                continue;
            }
            if (c2 == '\\') {
                bl3 = true;
                continue;
            }
            if (c2 == this.seperator) break;
            this.buf.append(c2);
        }
        this.index = n2;
        return this.buf.toString().trim();
    }
}

