/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    byte[][] lookupPowX2 = new byte[64][];

    public void init(byte[] byArray) {
        this.lookupPowX2[0] = GCMUtil.oneAsBytes();
        this.lookupPowX2[1] = Arrays.clone(byArray);
        for (int i2 = 2; i2 != 64; ++i2) {
            byte[] byArray2 = Arrays.clone(this.lookupPowX2[i2 - 1]);
            GCMUtil.multiply(byArray2, byArray2);
            this.lookupPowX2[i2] = byArray2;
        }
    }

    public void exponentiateX(long l2, byte[] byArray) {
        byte[] byArray2 = GCMUtil.oneAsBytes();
        int n2 = 1;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                GCMUtil.multiply(byArray2, this.lookupPowX2[n2]);
            }
            ++n2;
            l2 >>>= 1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, 16);
    }
}

